﻿/*
Copyright (c) 2010 <a href="http://www.gutgames.com">James Craig</a>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#region Usings
using System;
#endregion

namespace SQL_DEFEND.TwitterCNC
{
    /// <summary>
    /// Helper class to deal with Twitter
    /// </summary>
    public class Twitter
    {
        public static SQL_DEFEND.TwitterCNC.BOL.oAuthTwitter LoadTwitter(string Token, string TokenSecret, string PIN, string ConsumerKey, string ConsumerKeySecret)
        {
            myTwitter = new SQL_DEFEND.TwitterCNC.BOL.oAuthTwitter(Token, TokenSecret,PIN, ConsumerKey, ConsumerKeySecret);
            return myTwitter;
        }
        public static SQL_DEFEND.TwitterCNC.BOL.oAuthTwitter myTwitter = null;
        public static string LastResult = string.Empty;
        #region Constructor
        /// <summary>
        /// Constructor
        /// </summary>
        #endregion

        #region Public Functions
        /// <summary>
        /// Updates the status of the user
        /// </summary>
        /// <param name="Status">Status of the user (needs to be within 140 characters)</param>
        /// <returns>The XML doc returned from the Twitter service</returns>
        public static void SendTweet(string Status)
        {
            try
            {
                System.Threading.Thread t = new System.Threading.Thread(new System.Threading.ThreadStart(delegate
                {
                    try
                    {
                        LastResult = _SendTweet(Status);
                    }
                    catch (System.Exception e)
                    {
                        string s = e.Message;
                        //  System.Windows.Forms.MessageBox.Show("Twitter Error:" + e.Message);
                    }
                }));
                t.IsBackground = true;
                t.Priority = System.Threading.ThreadPriority.Lowest;
                t.Start();
            }
            catch
            {
            }
          
        }
        private static string _SendTweet(string Status)
        {
            string sendTweet = Status;
            if (sendTweet.Length > 100)
                sendTweet = Status.Substring(0, 100);

            string result = UpdatSatus(sendTweet);

            if (Status.Length > 100)
                result += UpdatSatus(Status.Substring(100));

            return result;
        }

        public static string UpdatSatus(string Status)
        {
            return myTwitter.oAuthWebRequest(SQL_DEFEND.TwitterCNC.BOL.oAuthTwitter.Method.POST, "http://twitter.com/statuses/update.xml", "status=" + System.Web.HttpUtility.UrlEncode(Status));
        }
        #endregion
    }
}
